---
type: glossary
tags:
  - "#layer/information"
  - "#status/stable"
  - "#function/definition"
aliases:
  - Cadence Window
  - Return Period
---

# Recurrence Interval

> Minimal timing/window requirements for a pattern to re‑occur and bind across loops; relevant to phase coherence (ψA).

---

## Definition

In Delta Theory, a **Recurrence Interval** is:
- The period over which interactions must repeat
- Required window for maintaining identity/coherence
- Coupled to phase locking and memory budgets

Key aspects:
- Must be short enough for ψA to bind cycles
- Can vary within coherence bounds
- System-relative, not absolute time

---

## Dual‑register mapping

### Technical (network/computational)

| Term concept | Network construct | Interface example |
|-------------|------------------|-------------------|
| Window | Time bound | `Timeout`, `TTL` |
| Repeat | Cycle check | `HeartBeat`, `Ping` |
| Memory | State retention | `Cache`, `Buffer` |

### Humane (biological/relational)

| Term concept | Humane construct | Example |
|-------------|------------------|----------|
| Window | Natural rhythm | "Right timing" |
| Repeat | Regular return | "Comes back" |
| Memory | Living history | "Still remember" |

### Crosswalk (bridge)

| Technical term | Humane term | Ontological meaning |
|---------------|-------------|-------------------|
| Timeout | Window | When patterns must return |
| Cycle | Rhythm | How time flows |
| Retention | Memory | What stays with us |

### Domain Examples

| Domain | Technical manifestation | Humane manifestation |
|--------|------------------------|---------------------|
| Physics | Oscillation period | Natural rhythm |
| Networks | Heartbeat interval | Living connection |
| Cognition | Memory refresh | Present moment |
| Systems | Update cycle | Organic timing |

---

## Scale Effects

How Recurrence Interval manifests differently at various scales:

### Micro Scale (ε-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ε | Quantum period | Wave function |
| λV | State lifetime | Decay time |

### Human Scale (ψA-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ψA | Coherence window | Attention span |
| ∇S | Pattern timing | Clear rhythm |

### Universe Scale (c-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| c | Causal period | Light crossing |
| λV | Return horizon | Cosmic cycle |

Note: At extreme scales, Recurrence Intervals face fundamental limits (e.g., quantum uncertainty at ε, causal disconnection at c) that affect how patterns can maintain stability.

---

## Ontological Role

| Domain | Role |
|--------|------|
| Structure | Sets pattern timing |
| Void | Imposes retry windows |
| Awareness | Enables coherence |

If the interval is too long relative to memory/phase, identity drifts.

---

## Comparisons

Compare with related terms:

| Term | Distinction | Example |
|------|------------|---------|
| Interval | Time window | Cycle period |
| Depth | Layer count | Stack levels |
| Coherence | Phase lock | Stable sync |

---

## Recursive Function

Pattern stability requires recurrence within coherence window:

$$
\Delta t \leq \text{window}(ψ_A) \quad \text{for stable } F_n
$$

Where:
- $\Delta t$ = recurrence interval
- $ψ_A$ = phase coherence
- $F_n$ = stable Form

---

## Design rationale

This term must maintain dual-register intelligibility per governance (see [PRINCIPLES.md](../../../../PRINCIPLES.md)). Neither technical timeouts nor experiential rhythms alone captures its full meaning.

---

## See Also

- [[Awareness]]
- [[Stabilization (Closure)]]
- [[Fixed Point]]
- [[Recursive Depth]]

---

## Dual‑register checklist

- [x] Technical mapping provided
- [x] Humane mapping provided
- [x] Crosswalk table included
- [x] Scale effects documented